<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Input;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Str;
use App\Models\Slider;
use App\Models\Category;
use App\Models\Posts;
use App\Models\Setting;
use App\Models\Language;
use App\Models\Section;
use App\Models\UserBusiness;
use App\Models\User;
use App\Models\VideoCategory;
use App\Models\GreetingSection;
use App\Models\Greeting;
use App\Models\Subscription;
use App\Models\Transaction;
use App\Models\Video;
use App\Models\FrameCategory;
use App\Models\UserFrame;
use App\Models\Frame;
use App\Models\UserPost;
use App\Models\Sticker;
use App\Models\StickerCategory;
use App\Models\OfferDialog;
use App\Models\Promocode;
use App\Models\Contact;
use App\Models\Music;
use App\Models\MusicCategory;
use App\Models\BusinessCardTamplate;
use App\Models\BusinessCardDigital;
use App\Models\Services;
use App\Models\ServiceInquiries;
use App\Models\Withdraw;
use App\Models\InvitationCategory;
use App\Models\InvitationCard;
use App\Models\PaytmChecksum;
use App\Models\UserTransaction;
use App\Models\SubCategory;
use App\Models\LogoCategory;
use App\Models\Background;;
use App\Models\AutomationFrame;

use App\Models\VideoTamplate;
use App\Models\VideoTamplateCategory;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Validator;
use PDF;
use File;
use Carbon\Carbon;
use Cache;
use DB;
class Controller extends BaseController

{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    
    function getAllSettings(){
        return Setting::get();
    }
    
    function getLanguage(){
        return Language::where('status','0')->get();
    }
    
    
    function automationProcess(Request $request){
        Cache::flush();
        Artisan::call('optimize:clear');
        Artisan::call('clear-compiled');
        File::deleteDirectory(public_path().'/uploads/autopost/');

        $totalBusiness = UserBusiness::where('time',Carbon::now()->format('H:i'))->where('automation','1')->get();
        $today_event = Category::where('event_date',date('Y-m-d',strtotime('today')))->take(4)->get();
        
        foreach ($totalBusiness as $business){
            
            $user = User::find($business->user_id);
            if($user->subscription_name != null){
            
                $number = $business->whatsapp;
                if(!str_starts_with($number,"+")) {
                    $number = "+91".$number;
                }
            
                if($business->auto_business == 1){
                    $poster = Posts::where('category_id',$business->category_id)->where('language',$business->auto_language)->inRandomOrder()->first();
                    if($poster){
                        
                        $business->background = $poster->item_url;
                        $customPaper = array(0,0,1500,1500);
                        
                        
                        $business->profile_pic = $user->profile_pic;
                        
                        $event = Category::find($business->category_id);
                        if($business->auto_frame_type == "auto-frame"){
                            if($business->type == "political"){
                                $politicalparty = Category::find($business->category_id);
                                $business->party_logo = $politicalparty->image;
                            }
                            $autoframe = AutomationFrame::find($business->auto_frame_id);
                            $pdf = PDF::loadView('automation.frames.'.$autoframe->blade_name,$business->toArray())->setPaper($customPaper, 'landscape');
                        
                            $random = Str::random(10);
                            $path = public_path().'/uploads/autopost/';
                            if (!File::exists($path)) {
                                File::makeDirectory($path, $mode = 0777, true, true);
                            }
                            file_put_contents("uploads/autopost/".$random.".pdf", $pdf->output());
                            
                            
                            $imagick = new \Imagick();
                            $imagick->readImage(public_path("uploads/autopost/".$random.".pdf"));
                            $saveImagePath = public_path("uploads/autopost/".$random.".jpg");
                            $imagick->writeImages($saveImagePath, true);
                            
                            $this->sendAutoPostToWhatsapp($number,$event,url("uploads/autopost/".$random.".jpg"));
                            
                        }else if($business->auto_frame_type == "user-frame"){
                            
                            $userframe = UserFrame::find($business->auto_frame_id);
                            $business->user_frame = $userframe->item_url;
                            
                            $pdf = PDF::loadView('automation.frames.personal',$business->toArray())->setPaper($customPaper, 'landscape');
                        
                            $random = Str::random(10);
                            $path = public_path().'/uploads/autopost/';
                            if (!File::exists($path)) {
                                File::makeDirectory($path, $mode = 0777, true, true);
                            }
                            file_put_contents("uploads/autopost/".$random.".pdf", $pdf->output());
                            
                            
                            $imagick = new \Imagick();
                            $imagick->readImage(public_path("uploads/autopost/".$random.".pdf"));
                            $saveImagePath = public_path("uploads/autopost/".$random.".jpg");
                            $imagick->writeImages($saveImagePath, true);
                            
                            $this->sendAutoPostToWhatsapp($number,$event,url("uploads/autopost/".$random.".jpg"));
                        }
                    }
                }
                
                if($business->auto_festival == 1){
                    
                    foreach ($today_event as $key => $event) {
                        $poster = Posts::where('category_id',$event->id)->where('language',$business->auto_language)->inRandomOrder()->first();
                        if($poster){
                            
                            $business->background = $poster->item_url;
                            $customPaper = array(0,0,1500,1500);
                            
                            $business->profile_pic = $user->profile_pic;
                            if($business->auto_frame_type == "auto-frame"){
                                if($business->type == "political"){
                                    $politicalparty = Category::find($business->category_id);
                                    $business->party_logo = $politicalparty->image;
                                }
                                $autoframe = AutomationFrame::find($business->auto_frame_id);
                                $pdf = PDF::loadView('automation.frames.'.$autoframe->blade_name,$business->toArray())->setPaper($customPaper, 'landscape');
                            
                                $random = Str::random(10);
                                $path = public_path().'/uploads/autopost/';
                                if (!File::exists($path)) {
                                    File::makeDirectory($path, $mode = 0777, true, true);
                                }
                                file_put_contents("uploads/autopost/".$random.".pdf", $pdf->output());
                                
                                
                                $imagick = new \Imagick();
                                $imagick->readImage(public_path("uploads/autopost/".$random.".pdf"));
                                $saveImagePath = public_path("uploads/autopost/".$random.".jpg");
                                $imagick->writeImages($saveImagePath, true);
                                
                                $this->sendAutoPostToWhatsapp($number,$event,url("uploads/autopost/".$random.".jpg"));
                                
                            }else if($business->auto_frame_type == "user-frame"){
                                
                                $userframe = UserFrame::find($business->auto_frame_id);
                                $business->user_frame = $userframe->item_url;
                                
                                $pdf = PDF::loadView('automation.frames.personal',$business->toArray())->setPaper($customPaper, 'landscape');
                            
                                $random = Str::random(10);
                                $path = public_path().'/uploads/autopost/';
                                if (!File::exists($path)) {
                                    File::makeDirectory($path, $mode = 0777, true, true);
                                }
                                file_put_contents("uploads/autopost/".$random.".pdf", $pdf->output());
                                
                                
                                $imagick = new \Imagick();
                                $imagick->readImage(public_path("uploads/autopost/".$random.".pdf"));
                                $saveImagePath = public_path("uploads/autopost/".$random.".jpg");
                                $imagick->writeImages($saveImagePath, true);
                                
                                $this->sendAutoPostToWhatsapp($number,$event,url("uploads/autopost/".$random.".jpg"));
                            }
                        }
                    }
                    
                }
            }
        }
        
        return "Success";
    }
    
    function sendAutoPostToWhatsapp($number,$event,$saveImagePath){
        
        $data['authkey'] = Setting::getValue('whatsapp_api_key');
        $data['appkey'] = Setting::getValue('whatsapp_app_key');
        $data['instance_id'] = Setting::getValue('whatsapp_instance_id');
        
        $msg = "#".Carbon::now()->format('d-m-y');
        $msg .= "\n".$event->name;
        
        $data['message'] = $msg;
        $url = "https://wspsender.visticsolutions.in/api/message-send";
        
        $data['to'] = $number;
        $data['file'] = url($saveImagePath);
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $result = curl_exec($ch);
        curl_close($ch);
    }
    
    function whatsappOtp(Request $request){
        
        $number = $request->get('number');
        $otp = random_int(100000, 999999);

       
        $data['authkey'] = Setting::getValue('whatsapp_api_key');
        $data['appkey'] = Setting::getValue('whatsapp_app_key');
        $data['instance_id'] = Setting::getValue('whatsapp_instance_id');
        
        $data['message'] = "<#>".$otp." is your one time password to proceed on ".Setting::getValue('app_name')." ";
        $url = "https://wspsender.visticsolutions.in/api/message-send";
        
        $data['to'] = $number;
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $result = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($result,true);
        if(!isset($result['error'])){
            $out['code'] = 200;
            $out['message'] = "Success";
            $out['otp'] = $otp;
        }else{
            $out['code'] = 201;
            $out['message'] = $result['key'];
            $out['otp'] = "";
        }
        
        return response()->json($out);
    }
    
    function getVideoTamplates(Request $request){
        $category = $request->get('category');
        $videos = VideoTamplate::where('status','0');
        
        if($category != ""){
            $videos->where('category_id',$category);
        }
        
        $out = $videos->latest()->get();
        return response()->json($out);
    }
    
    function getMusicbyCategory(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['musiccategories'] = MusicCategory::with('musics')->where('status','0')->orderBy('orders','ASC')->get();
        return response()->json($out);
    }
    
    function getInvitationCategories(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['invitationcategories'] = InvitationCategory::with('invitationcards')->where('status','0')->orderBy('id',"DESC")->get();
        return response()->json($out);
    }
    
    function getInvitationCardsByCatId(Request $request){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['customTamplates'] = InvitationCard::where('category_id',$request->get('category'))->where('status','0')->orderBy('id',"DESC")->get();
        return response()->json($out);
    }
    
    function getServices(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['services'] = Services::where('status','0')->orderBy('id',"DESC")->get();
        return response()->json($out);
    }
    
    
    function getBackgrounds(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['backgrounds'] = Background::orderBy('id',"DESC")->get();
        return response()->json($out);
    }
    
    function getUserCategory(Request $request){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['usercategory'] = Category::find($request->get('category_id'));
        return response()->json($out);
    }
    
    
    function getUserTransactionList(Request $request){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['transactionlist'] = UserTransaction::where('user_id',$request->get('user_id'))->orderBy('id','DESC')->get();
        return response()->json($out);
    }
    
    function getUserWithdrawList(Request $request){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['balance'] = User::find($request->get('user_id'))->balance;
        $out['total_withdraw'] = Withdraw::where('user_id',$request->get('user_id'))->sum('amount');
        $out['withdrawlist'] = Withdraw::where('user_id',$request->get('user_id'))->orderBy('id','DESC')->get();
        return response()->json($out);
    }
    
    function withdrawRequest(Request $request){
        
        $user = User::find($request->get('user_id'));
        $upi= $request->get('upi');
        if($user){
            $withdraw = new Withdraw();
            $withdraw->user_id = $user->id;
            $withdraw->amount = $user->balance;
            $withdraw->upi_id = $upi;
            $withdraw->status = "pending";
            $withdraw->save();
            
            $userTrans = new UserTransaction();
            $userTrans->user_id = $user->id;
            $userTrans->other_user_id = 0;
            $userTrans->title = "Withdraw Amount";
            $userTrans->amount = $user->balance;
            $userTrans->type = "debit";
            $userTrans->save();
                
            $user->balance = 0;
            $user->save();
            
            $out['message'] = "Withdraw Success";
        }else{
            $out['message'] = "Withdraw faild";
        }
        
        $out['code'] = 200;
        return response()->json($out);
    }
    
    function getUserInviteList(Request $request){
        $user = User::find($request->get('user_id'));
        if($user){
            $out['code'] = 200;
            $out['message'] = "Success";
            $out['userslist'] = User::where('refered',$user->refer_id)->orderBy('id','DESC')->get();
        }else{
            $out['code'] = 201;
            $out['message'] = "No user found";
            $out['userslist'] = array();
        }
        
        return response()->json($out);
    }
    
    function getBusinessCards(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['businesscarddigital'] = BusinessCardDigital::where('status','0')->get();
        $out['businesscardtamplate'] = BusinessCardTamplate::where('status','0')->get();
        return response()->json($out);
    }
    
    function getDailyPosts(Request $request){
        
        $page = $request->get("page");
        
        $languages = "";
        
        if($request->get("language") != ""){
            $languages = json_decode($request->get("language"),true);
        }else{
            $languages = Language::select('language_code')->where('status','0')->get();
        }
        
        $posts = Posts::whereIn('language',$languages)->where('status','0');
        
        if($request->get("search") == 'daily'){
            $today_event = Category::select('id')->where('event_date',date('Y-m-d',strtotime('today')))->get();
            $posts->whereIn('category_id',$today_event);
        }else{
            $posts->where('category_id',$request->get("search"));
        }
        
        
        $posts->skip($page*20)->take(20);
        $out['daily_post'] = $posts->inRandomOrder()->get();
        $out['custom_category'] = Category::where('type','custom')->where('status','0')->orderBy('updated_at','DESC')->get();
        
        return response()->json($out);
        
    }
    
    
    function getHomeData(Request $request){
        
        $languages = "";
        if($request->get("language") != ""){
            $languages = json_decode($request->get("language"),true);
        }else{
            $languages = Language::select('language_code')->where('status','0')->get();
        }
        
        $out['code'] = 200;
        $out['message'] = "Success";
        
        $out['slider'] = Slider::where('status','0')->get();
        
        $offerdialog = OfferDialog::where('status','0')->inRandomOrder()->take(1)->get();
        if(count($offerdialog) > 0){
            $out['offerdialog'] = $offerdialog[0];
        }
        

        $user = User::find($request->get('user_id'));
        
        if($user){
            $category = $user->category_id;
        }
        
        if($request->get("category") != ""){
            $category = $request->get("category");
        }
        
        if($user){
            $out['foryou'] = Posts::whereIn('language',$languages)->where('status','0')->where('category_id',$category)->inRandomOrder()->take(8)->get();
        }
        
        $out['section'] = Section::with(array('posts'=>function($query){
                $query->where('status','0')->orderBy('id',"DESC")->limit(7);
            }))->where('status','0')->orderBy('orders',"ASC")->get();
            
        $featured_list = array();
        $featured = Category::where('featured','1')->where('status','0')->orderBy('updated_at',"DESC")->get();
        foreach($featured as $featur){
            $posts = Posts::where('category_id',$featur->id)->where('status','0')->orderBy('id',"DESC")->take(10)->get();
            if(count($posts) > 0){
                $featur['posts'] = $posts;
                $featured_list[] = $featur;
            }
           
        }
        
        if(count($featured_list) > 0){
            $out['featured'] = $featured_list;
        }else{
            $out['featured'] = array();
        }
        
        $out['video_tamplate_category'] = array();
        $out['video_tamplate_categories'] = VideoTamplateCategory::with(array('videos'=>function($query){
                 $query->latest()->limit(1);
            }))->where('status','0')->orderBy('orders',"ASC")->get();
        
        $out['upcoming_event'] = Category::whereBetween('event_date',[date('Y-m-d',strtotime('today')),date('Y-m-d',strtotime('+7 days'))])->where('status','0')->orderBy('event_date','ASC')->get();
        
        $festival_calendar = Category::select("event_date")
                ->whereBetween('event_date',[date('Y-m-d',strtotime('today')),date('Y-m-d',strtotime('+7 days'))])
                ->where('status','0')
                ->groupBy(DB::raw('event_date'))
                ->orderBy('event_date','ASC')
                ->get();
                
        foreach ($festival_calendar as $fc){
            
            $category = Category::where("event_date",$fc['event_date'])->where('status','0')->get();
            $fc['categories'] = $category;
            
        }
        
        $out['festivalCalendar'] = $festival_calendar;
        
        $out['customTamplateCategory'] = InvitationCategory::where('status','0')->inRandomOrder()->get();
        $out['festival_category'] = Category::where('type','festival')->where('status','0')->orderBy('name','ASC')->take(8)->get();
        $out['business_category'] = Category::where('type','business')->where('status','0')->orderBy('name','ASC')->take(9)->get();
        $out['political_category'] = Category::where('type','political')->where('status','0')->orderBy('name','ASC')->take(12)->get();
        $out['custom_category'] = Category::where('type','custom')->where('status','0')->orderBy('name','ASC')->take(12)->get();
        $out['daily_post'] = Posts::whereIn('language',$languages)->where('type','custom')->where('status','0')->take(6)->inRandomOrder()->get();
        $out['recent'] = Posts::whereIn('language',$languages)->where('status','0')->orderBy('id','DESC')->take(12)->get();
        return response()->json($out);
    }
    
    
    function getBusinessPoliticalCategory(Request $request){
        $category = Category::where('type','!=','festival')->where('type','!=','custom')->where('status','0');
        if($request->search != ""){
            $category->where('name','like',"%".$request->search."%");
        }
        if($request->type != "" && $request->type != "all"){
            $category->where('type',$request->type);
        }
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['business_political_category'] = $category->get();
        return response()->json($out);
    }
    
    
    function getVideoCategoryData(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['upcoming_event'] = VideoCategory::whereBetween('event_date',[date('Y-m-d',strtotime('today')),date('Y-m-d',strtotime('+7 days'))])->where('status','0')->get();
        $out['festival_category'] = VideoCategory::where('type','festival')->where('status','0')->get();
        $out['business_category'] = VideoCategory::where('type','business')->where('status','0')->get();
        $out['custom_category'] = VideoCategory::where('type','custom')->where('status','0')->get();
        return response()->json($out);
    }
    
    function getGreetingData(Request $request){
        
        $languages = "";
        $page = $request->get("page");
        $search = $request->get('search');
        
        if($request->get("language") != ""){
            $languages = json_decode($request->get("language"),true);
        }else{
            $languages = Language::select('language_code')->where('status','0')->get();
        }
        
        $posts = GreetingSection::with(array('posts'=>function($query){
                $query->where('status','0');
                $query->latest()->limit(7);
            }))->where('status','0');
        
        if($search != ""){
            $posts->where('name','like',"%".$search."%");
        }else{
            $posts->orderBy('orders',"ASC")->skip($page*5)->take(5);
        }
        
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['greeting_section'] = $posts->get();
        return response()->json($out);
    }
    
    function getFrames(Request $request){
        $CategoryList = FrameCategory::where('status','0')->orderBy('id',"DESC")->get();
        foreach ($CategoryList as $key => $framec){
            $frameList = Frame::where('category_id',$framec->id)->where('ratio',$request->get('ratio'))->where('status','0')->get();
            $CategoryList[$key]['frames'] = $frameList;
        }
        
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['framecategories'] = $CategoryList;
        return response()->json($out);
    }
    
    function getFramesByType(Request $request){
        
        $frames = Frame::where('type',$request->get('type'))->where('ratio',$request->get('ratio'))->where('status','0');
        
        // if($request->get('animated') == "true"){
        //     $frames->where('frame_zip','!=',null);
        // }else{
        //     $frames->where('frame_zip',null);
            $out['userframes'] = UserFrame::where('user_id',$request->get('user_id'))->where('status','0')->inRandomOrder()->get();
        // }
        
        
        if($request->get('featured') == "true"){
            $frames->where('featured','1');
        }
        
        $out['frames'] = $frames->inRandomOrder()->get();
        
        $out['code'] = 200;
        $out['message'] = "Success";
        return response()->json($out);
    }
    
    function getAutomationFramesByType(Request $request){
        
        $frames = AutomationFrame::where('type',$request->get('type'))->where('status','0');
        
        $out['automationframes'] = $frames->inRandomOrder()->get();
        
        $out['userframes'] = UserFrame::where('user_id',$request->get('user_id'))->where('status','0')->inRandomOrder()->get();
        
        $out['code'] = 200;
        $out['message'] = "Success";
        return response()->json($out);
    }
    
    function getStickerbyCategory(Request $request){
        $search = $request->get('search');
        
        
        if($search != ""){
            $stickers = StickerCategory::with('stickers')->where('status','0')->where('name','like',"%".$search."%")->orderBy('id',"DESC")->get();
            $data = array();
            foreach ($stickers as $sticker){
                $data = $sticker['stickers'];
            }
            $out['stickers'] = $data;
        }else{
            $stickers = StickerCategory::with('stickers')->where('status','0');
            $out['stickercategory'] = $stickers->orderBy('id',"DESC")->get();
        }
        $out['code'] = 200;
        $out['message'] = "Success";
        return response()->json($out);
    }
    
    function getLogosbyCategory(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['logoscategory'] = LogoCategory::with('logos')->where('status','0')->orderBy('id',"DESC")->get();
        return response()->json($out);
    }
    
    function showFrameView($id){
        $data['data'] = Frame::find($id);
        return view('frame.show',$data);
    }
    
    
    function cheakPromocode(Request $request){
        
        $code = $request->get('code');
        $promo = Promocode::where('code',$code)->where('status','0')->first();
        if($promo){
            $total = Transaction::where('promocode',$code)->count();
            if($total >= $promo->total_use){
                $out['code'] = 201;
                $out['message'] = "Promocode Limit Reached";
                return response()->json($out);
            }else{
                $out['code'] = 200;
                $out['message'] = "Applied";
                $out['promocode'] = $promo;
                return response()->json($out);
            }
        }else{
            $out['code'] = 201;
            $out['message'] = "Invalid Promocode";
            return response()->json($out);
        }
    }
    
    
    function getUserFrames(Request $request){
        $user_id = $request->get('user_id');
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['userframes'] = UserFrame::where('user_id',$user_id)->where('status','0')->orderBy('id',"DESC")->get();
        
        return response()->json($out);
    }
    
    function getPremiumPostsbyCategory($type){
        $out['code'] = 200;
        $out['message'] = "Success";
        if($type == "video"){
            $out['categories'] = VideoCategory::with('premiumposts')->where('status','0')->inRandomOrder()->get();
        }else{
            $out['categories'] = Category::with('premiumposts')->where('type',$type)->where('status','0')->inRandomOrder()->get();
        }
        return response()->json($out);
    }
    
    function getCategoriesbyPage(Request $request){
        $page = $request->get('page');
        $type = $request->get('type');
        $search = $request->get('search');
        
        $categories = Category::where('status','0');
        
        if($type != ""){
            $categories->where('type',$type);
        }
        
        if($search != ""){
            $categories->where('name','like',"%".$search."%");
        }
        
        if($search == ""){
            $categories->skip($page*20)->take(20);
        }
        
        if($type == "festival"){
            $categories->orderBy('updated_at','DESC');
        }else{
            $categories->orderBy('id','DESC');
        }
        
        
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['categories'] = $categories->get();
        return response()->json($out);
    }
    
    function getSearchSuggestion(Request $request){
        $out = array();
        if($request->get('search') != ""){
            $categories = Category::select('name')->where('name','like',"%".$request->get('search')."%")->get();
            foreach ($categories as $category){
                $out[]=$category['name'];
            }
        }
        return response()->json($out);
    }
    
    function getVideoTamplateCategoriesBypage(Request $request){
        $page = $request->get('page');
        $type = $request->get('type');
        $search = $request->get('search');
        
        $categories = VideoTamplateCategory::with(array('videos'=>function($query){
                 $query->latest()->limit(1);
            }))->where('status','0');
        
        if($type != ""){
            $categories->where('type',$type);
        }
        
        if($search != ""){
            $categories->where('name','like',"%".$search."%");
        }
        
        if($search == ""){
            $categories->skip($page*20)->take(20);
        }
        
        $categories->orderBy('id','DESC');
        
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['video_tamplate_categories'] = $categories->get();
        return response()->json($out);
    }
    
    function addContact(Request $request){
        $user_id = $request->get('user_id');
        $number = $request->get('number');
        $message = $request->get('message');
        
        $contact = new Contact();
        $contact->user_id = $user_id;
        $contact->number = $number;
        $contact->message = $message;
        
        $contact->save();
        return response()->json([
            'code' => 200,
            'message' => "Message Send Successfully"
        ]);
    }
    
    function addInquiry(Request $request){
        $user_id = $request->get('user_id');
        $service_id = $request->get('service_id');
        $number = $request->get('number');
        $message = $request->get('message');
        
        $contact = new ServiceInquiries();
        $contact->user_id = $user_id;
        $contact->service_id = $service_id;
        $contact->number = $number;
        $contact->message = $message;
        
        $contact->save();
        return response()->json([
            'code' => 200,
            'message' => "Inquiry Submit Successfully"
        ]);
    }
    
    function getPostsbyPage(Request $request){
        $page = $request->get('page');
        $type = $request->get('type');
        $post_type = $request->get('post_type');
        $item_id = $request->get('item_id');
        $search = $request->get('search');
        $subcategory = $request->get('subcategory');
        $postid = $request->get('postid');
        
        $languages = "";
        if($request->get("language") != ""){
            $languages = json_decode($request->get("language"),true);
        }else{
            $languages = Language::select('language_code')->where('status','0')->get();
        }
        
        if($post_type == "video"){
            $posts = Video::where('status','0');
        }else if($post_type == "greeting"){
            $posts = Greeting::where('status','0');
        }else {
            $posts = Posts::where('status','0');
        }
        
        if($subcategory != ''){
            $posts->where('sub_category_id',$subcategory);
        }
        
        if($type == "category"){
            $posts->where('category_id',$item_id);
        }
        
        if($languages != ""){
            $posts->whereIn('language',$languages);
        }
        
        if($type == "section"){
            $posts->where('section_id',$item_id);
        }
        
        if($search != ""){
            $posts->where('title','like',"%".$search."%");
        }
        
        if($search == ""){
            $posts->skip($page*20)->take(20);
        }
        
        $posts->orderBy('id','DESC');
        
        $posts = $posts->get();
        
        if(count($posts) > 0 && $post_type != "greeting"){
            $out['subcategories'] = SubCategory::where('category_id',$posts[0]["category_id"])->where('status','0')->get();
        }else{
            $out['subcategories'] = array();
        }
        
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['posts'] = $posts;
        
        return response()->json($out);
    }
    
    function updatePostViews(Request $request){
        $id = $request->get('id');
        $type = $request->get('type');
        
        if($type == "video"){
            $posts = Video::find($id);
        }else if($type == "greeting"){
            $posts = Greeting::find($id);
        }else {
            $posts = Posts::find($id);
        }
        
        $posts->views = $posts->views+1;
        $posts->save();
        $out['code'] = 200;
        $out['message'] = "Success";
        return response()->json($out);
    }
    
    function getSubscriptionPlan(){
        $out['code'] = 200;
        $out['message'] = "Success";
        $out['subscriptions'] = Subscription::where('status','0')->orderBy('id',"DESC")->get();
        return response()->json($out);
    }
    
    function offlineSuscription(Request $request){
        
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|string|exists:users,id',
            'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                'code' => 201,
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ]);
        }
        
        $user_id = $request->get('user_id');
        $subs_id = $request->get('subscription_id');
        $promocode = $request->get('promocode');
        $type = $request->get('type');
        $amount = $request->get('amount');
        
        if ($request->file("image")) {
            if ($request->file("image") && $request->file('image')->isValid()) {
                $image = $request->file("image");
                
                $extension = $image->getClientOriginalExtension();
                $fileName = Str::uuid() . '.' . $extension;
                $image->move('uploads/profile', $fileName);
                $item_url = 'uploads/profile/'.$fileName;
                
                $subs = Subscription::find($subs_id);
                $trans = new Transaction();
                
                $trans = new Transaction();
                $trans->user_id = $user_id;
                $trans->plan = $subs->name;
                $trans->amount = $amount;
                $trans->promocode = $promocode;
                $trans->payment_type = $type;
                $trans->status = "pending";
                $trans->receipt = $item_url;
                $trans->transaction_id = "Offline";
                $trans->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "We have received your request, action will be taken soon.",
                ]);
            }
        }else{
            return response()->json([
                'code' => 201,
                'message' => "No file found",
                'user' => ""
            ]);
        }
    }
    
    
    function updateDeviceToken(Request $request){
        $user_id = $request->get('user_id');
        $token = $request->get('token');
        
        $user = User::find($user_id);
        $user->device_token = $token;
        $user->save();
        
        return response()->json([
                'code' => 200,
                'message' => "Update Success",
                'user' => $user
            ]);
    }
    
    function updateUserSubscription(Request $request){
        $user_id = $request->get('user_id');
        $subs_id = $request->get('subscription_id');
        $transaction_id = $request->get('transaction_id');
        $promocode = $request->get('promocode');
        $type = $request->get('type');
        $amount = $request->get('amount');
        
        $user = User::find($user_id);
        $subs = Subscription::find($subs_id);
        
        if($user && $subs){
            $start_date = date('Y-m-d');
            $end_date = date('Y-m-d', strtotime($subs->value." ".$subs->type));
            
            if($user->refered != null){
                $refer_user = User::where('refer_id',$user->refered)->first();
                $percentage = Setting::getValue('refer_subscription_bonus');
                $uamount = ($percentage / 100) * $amount;
                $refer_user->balance = $refer_user->balance + $uamount;
                $refer_user->save();
                
                $userTrans = new UserTransaction();
                $userTrans->user_id = $refer_user->id;
                $userTrans->other_user_id = $user->id;
                $userTrans->title = "Subscription Bonus By ".$user->name;
                $userTrans->amount = $amount;
                $userTrans->type = "credit";
                $userTrans->save();
            }
            
            $user->subscription_id = $subs->id;
            $user->subscription_name = $subs->name;
            $user->subscription_price = $amount;
            $user->subscription_date = $start_date;
            $user->subscription_end_date = $end_date;
            
            $user->festival = $subs->festival;
            $user->business = $subs->business;
            $user->political = $subs->political;
            $user->video = $subs->video;
            
            $user->daily_limit = $subs->daily_limit;
            $user->posts_limit = $user->posts_limit+$subs->posts_limit;
            $user->business_limit = $subs->business_limit;
            $user->political_limit = $subs->political_limit;
            
            $user->save();
            
            $trans = new Transaction();
            $trans->user_id = $user_id;
            $trans->plan = $subs->name;
            $trans->amount = $amount;
            $trans->promocode = $promocode;
            $trans->payment_type = $type;
            $trans->transaction_id = $transaction_id;
            $trans->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Subscription has been applied Successfully",
                'user' => $user
            ]);
        }else{
            return response()->json([
                'code' => 201,
                'message' => "Faild to upadte",
                'user' => $user
            ]);
        }
    }
    
    
    
    function loginUser(Request $request){
        
        
        $allusers = User::where('login',null)->get();
        foreach ($allusers as $alluser){
            $edit = User::find($alluser->id);
            if($alluser->social == "google"){
                $edit->login = $alluser->email;
            }else{
                $edit->login = $alluser->number;
            }
            $edit->save();
        }
        
        $social = $request->get('social');
        $social_id = $request->get('social_id');
        $auth_token = $request->get('auth_token');
        $device_token = $request->get('device_token');
        $name = $request->get('name');
        $email = $request->get('email');
        $number = $request->get('number');
        $profile_pic = $request->get('profile_pic');
        $login = '';
        $user = array();
        if($social == "phone"){
            $user = User::where('login',$number)->where('social','phone')->first();
            $login = $number;
        }elseif ($social == "whatsapp") {
            $user = User::where('login',$number)->where('social','whatsapp')->first();
            $login = $number;
        }elseif ($social == "google") {
            $user = User::where('login',$email)->where('social','google')->first();
            $login = $email;
        }elseif ($social == "facebook") {
            $user = User::where('login',$email)->first();
            $login = $email;
        }else{
            $user = User::where('login',$email)->first();
            $login = $email;
        }
        
        if($user){
            return response()->json([
                'code' => 200,
                'message' => "Login Successfull",
                'user' => $user
            ]);
        }else{
            
            $referCode = $this->createRandomPassword();
            
            $user = new User();
            $user->name = $name;
            $user->profile_pic = $profile_pic;
            $user->email = $email;
            $user->number = $number;
            $user->login = $login;
            $user->social = $social;
            $user->social_id = $social_id;
            $user->auth_token = $auth_token;
            $user->device_token = $device_token;
            $user->refer_id = $referCode;
            $user->save();
            return response()->json([
                'code' => 200,
                'message' => "Register Successfull",
                'user' => $user
            ]);
        }
    }
    
    function cheakReferCode(Request $request){
        $user = User::where('refer_id',$request->get('code'))->first();
        return response()->json([
            'code' => 200,
            'message' => "Success",
            'user' => $user
        ]);
    }
    
    function createRandomPassword() { 

        $chars = "ABCDEFGHIJKLMNOPQESTUVWXYZ023456789"; 
        srand((double)microtime()*1000000);
        $i = 0;
        $pass = '';
    
        while ($i <= 7) {
            $num = rand() % 33; 
            $tmp = substr($chars, $num, 1); 
            $pass = $pass . $tmp; 
            $i++; 
        }
    
        return $pass; 
    
    }
    
    function updateProfile(Request $request){
        $user = User::find($request->get('user_id'));
        if ($user) {
            $user->name = $request->get('name');
            $user->email = $request->get('email');
            $user->number = $request->get('number');
            $user->state = $request->get('state');
            $user->district = $request->get('district');
            $user->designation = $request->get('designation');
            
            $user->category_id = $request->get('category');
            
            
            if($request->get('refer_code') != ""){
                $user->refered = $request->get('refer_code');
                $refer_user = User::where('refer_id',$request->get('refer_code'))->first();
                if($refer_user){
                    $refer_user->balance = ($refer_user->balance +  Setting::getValue('refer_bonus'));
                    $refer_user->save();
                    
                    $userTrans = new UserTransaction();
                    $userTrans->user_id = $refer_user->id;
                    $userTrans->other_user_id = $user->id;
                    $userTrans->title = $user->name." Join by your refer code ";
                    $userTrans->amount = Setting::getValue('refer_bonus');
                    $userTrans->type = "credit";
                    $userTrans->save();
                
                }
            }
            $user->save();
            return response()->json([
                'code' => 200,
                'message' => "Successfull",
                'user' => $user
            ]);
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no file found",
                'user' => $user
            ]);
        }
    }
    
    function updateProfilePicture(Request $request){
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|string|exists:users,id',
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                'code' => 201,
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ]);
        }
        
        $user = User::find($request->get('user_id'));
        
        if ($user && $request->file("image")) {
            if ($request->file("image") && $request->file('image')->isValid()) {
                $image = $request->file("image");
                
                $extension = $image->getClientOriginalExtension();
                $fileName = Str::uuid() . '.' . $extension;
                $image->move('uploads/profile', $fileName);
                $item_url = 'uploads/profile/'.$fileName;
                
                $user->profile_pic = $item_url;
                $user->save();
                
                return response()->json([
                    'code' => 200,
                    'message' => "Successfull",
                    'user' => $user
                ]);
            }
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no file found",
                'user' => $user
            ]);
        }
    }
    
    
    function getUserPosts(Request $request){
        
        $user = User::find($request->get('user_id'));
        
        if ($user) {
            
            $userpost = UserPost::where('user_id',$user->id)->orderBy('id','DESC')->get();
            
            return response()->json([
                'code' => 200,
                'message' => "Successfull",
                'userposts' => $userpost
            ]);
            
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no user found",
                'userposts' => []
            ]);
        }
    }
    
    function uploadUserPost(Request $request){
        
        $user = User::find($request->get('user_id'));
        
        if ($user) {
            if($user->posts_limit > 0){
                $user->posts_limit = $user->posts_limit-1;
            }
            if($user->daily_limit > 0){
                $user->daily_limit = $user->daily_limit-1;
            }
            
            $user->save();
            
            return response()->json([
                'code' => 200,
                'message' => "Successfull",
                'user' => $user
            ]);
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no user found",
                'user' => $user
            ]);
        }
    }
    
    function geUserProfile(Request $request){
        
        $user = User::find($request->get('user_id'));
        
        if ($user) {
            
            if($user->subscription_name != NULL){
                if($user->active_at != date('Y-m-d')){
                    $subs = Subscription::find($user->subscription_id);
                    if($subs){
                        if($subs != NULL && $subs->daily_limit == 0){
                            $user->daily_limit = 777;
                        }else{
                            $user->daily_limit = $subs->daily_limit;
                        }
                        $user->active_at = date('Y-m-d');
                        $user->save();
                    }
                    
                }
            }
        
            if($user->status == 0){
                return response()->json([
                    'code' => 200,
                    'message' => "Success",
                    'user' => $user
                ]);
            }else{
                return response()->json([
                    'code' => 201,
                    'message' => "Your Account Blocked By Admin",
                    'user' => ''
                ]);
            }
        }else{
            return response()->json([
                'code' => 201,
                'message' => "Invalid user",
                'user' => $user
            ]);
        }
    }
    
    function getUserBusiness(Request $request){
        $user = User::find($request->get('user_id'));
        if ($user) {
            if($user->status == 0){
                
                return response()->json([
                    'code' => 200,
                    'message' => "Success",
                    'businesses' => UserBusiness::with('category')->where('user_id',$user->id)->where('type',$request->get('type'))->get()
                ]);
            }else{
                return response()->json([
                    'code' => 201,
                    'message' => "Your Account Blocked By Admin",
                    'businesses' => ''
                ]);
            }
        }else{
            return response()->json([
                'code' => 201,
                'message' => "Invalid user",
                'businesses' => ''
            ]);
        }
    }
    
    function getUserBusinessDetail(Request $request){
        $business = UserBusiness::find($request->get('id'));
        if ($business) {
            return response()->json([
                'code' => 200,
                'message' => "Success",
                'business' =>$business
            ]);
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no business found",
                'business' => ''
            ]);
        }
    }
    
    function deleteBusiness(Request $request){
        $business = UserBusiness::find($request->get('id'));
        if ($business) {
            @unlink($business->image);
            $business->delete();
            return response()->json([
                'code' => 200,
                'message' => "Delete Successfully"
            ]);
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no business found",
                'business' => ''
            ]);
        }
    }
    
    
    function addUserBusiness(Request $request){
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|string|exists:users,id',
            'image' => 'nullable|mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                'code' => 201,
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ]);
        }
        
        $user = User::find($request->get('user_id'));
        if ($user) {
            if($user->status == 0){
                
                $business = null;
                if($request->get('id') != ""){
                    $business = UserBusiness::find($request->get('id'));
                }
                
                if(!$business){
                    $business = new UserBusiness();
                }
                
                
                if($request->file("image") && $request->file('image')->isValid()){
                    
                    $image = $request->file("image");
                
                    $extension = $image->getClientOriginalExtension();
                    $fileName = Str::uuid() . '.' . $extension;
                    $image->move('uploads/profile', $fileName);
                    $item_url = 'uploads/profile/'.$fileName;
                    
                    @unlink($business->image);
                    $business->image = $item_url;
                    
                }
                
                if ($request->has('user_id')) $business->user_id = $request->get('user_id');
                if ($request->has('company')) $business->company = $request->get('company');
                if ($request->has('name')) $business->name = $request->get('name');
                if ($request->has('about')) $business->about = $request->get('about');
                if ($request->has('number')) $business->number = $request->get('number');
                if ($request->has('designation')) $business->designation = $request->get('designation');
                if ($request->has('address')) $business->address = $request->get('address');
                if ($request->has('email')) $business->email = $request->get('email');
                if ($request->has('category_id')) $business->category_id = $request->get('category_id');
                if ($request->has('website')) $business->website = $request->get('website');
                if ($request->has('whatsapp')) $business->whatsapp = $request->get('whatsapp');
                if ($request->has('facebook')) $business->facebook = $request->get('facebook');
                if ($request->has('twitter')) $business->twitter = $request->get('twitter');
                if ($request->has('youtube')) $business->youtube = $request->get('youtube');
                if ($request->has('instagram')) $business->instagram = $request->get('instagram');
                if ($request->has('type')) $business->type = $request->get('type');
                                
                
                if ($request->has('automation')){
                 
                    if($request->get('automation') == "true"){
                        $business->automation = 1;
                    }else{
                        $business->automation = 0;
                    }
                    if($request->get('auto_festival') == "true"){
                        $business->auto_festival = 1;
                    }else{
                        $business->auto_festival = 0;
                    }
                    if($request->get('auto_business') == "true"){
                        $business->auto_business = 1;
                    }else{
                        $business->auto_business = 0;
                    }
                    
                    if($request->get('time')){
                        
                        $timeInput = $request->get('time');
                        $parts = explode(':', $timeInput);
                        if (count($parts) === 2) {
                            $hours = str_pad($parts[0], 2, '0', STR_PAD_LEFT);
                            $minutes = str_pad($parts[1], 2, '0', STR_PAD_LEFT);
                            $normalizedTime = $hours . ':' . $minutes;
                        
                            // Now use Carbon
                            $formattedTime = Carbon::createFromFormat('H:i', $normalizedTime)->format('H:i');
                            $business->time = $formattedTime;
                            
                        } else {
                            // Handle invalid input
                            return response()->json(['error' => 'Invalid time format'], 422);
                        }
    
                        $business->auto_frame_type = $request->get('auto_frame_type');
                        $business->auto_frame_id = $request->get('auto_frame_id');
                        if($request->get('auto_language') != ""){
                            $business->auto_language = $request->get('auto_language');
                        }else{
                            $business->auto_language = "en";
                        }
                    }
                    
                }

                $business->save();
                
                $business['category'] = Category::find($business->category_id);
                
                return response()->json([
                    'code' => 200,
                    'message' => "Bussiness Saved Successfully",
                    'business' => $business,
                ]);
            }else{
                return response()->json([
                    'code' => 201,
                    'message' => "Your Account Blocked By Admin",
                    'business' => ''
                ]);
            }
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no user found",
                'business' => ''
            ]);
        }
    }
    
    function createUserBusinessCard(Request $request){
        $card = BusinessCardDigital::find($request->get('card_id'));
        $business = UserBusiness::find($request->get('business_id'));
        if($business){
            
            $customPaper = array(0,0,660,439);
            $pdf = PDF::loadView('cardtamplate.'.$card->blade_name,$business->toArray())->setPaper($customPaper, 'landscape');
            $random = Str::random(10);
            
            
            $path = public_path().'/uploads/pdf/';
            if (!File::exists($path)) {
                File::makeDirectory($path, $mode = 0777, true, true);
            }
            
            file_put_contents("uploads/pdf/".$random.".pdf", $pdf->output());
            
            return response()->json([
                'code' => 200,
                'message' => asset('uploads/pdf/'.$random.".pdf"),
            ]);
        
        }else{
            return response()->json([
                'code' => 201,
                'message' => "no business found"
            ]);
        }
    }
    
    function paytmPayment(Request $request){
        
        $order_id = $request->get("order_id");
        $cust_id = $request->get("cust_id");
        $amount = $request->get("amount");
        
        $paytmParams = array();
            
        $callback_url = "https://securegw.paytm.in/theia/paytmCallback?ORDER_ID=".$order_id;
        $paytmParams["body"] = array(
            "requestType"   => "Payment",
            "mid"           => Setting::getValue('paytm_merchant_id'),
            "websiteName"   => "Hello",
            "orderId"       => $order_id,
            "callbackUrl"   => $callback_url,
            "txnAmount"     => array(
                "value"     => $amount,
                "currency"  => "INR",
            ),
            "userInfo"      => array(
                "custId"    => 1,
            ),
        );

        $paytm_checksum = PaytmChecksum::generateSignature(json_encode($paytmParams["body"], JSON_UNESCAPED_SLASHES),Setting::getValue('paytm_merchant_key'));

        $paytmParams["head"] = array(
            "signature"    => $paytm_checksum
        );
            
        $post_data = json_encode($paytmParams, JSON_UNESCAPED_SLASHES);
        
        $url = "https://securegw.paytm.in/theia/api/v1/initiateTransaction?mid=".Setting::getValue('paytm_merchant_id')."&orderId=".$order_id;
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json")); 
        $response = json_decode(curl_exec($ch),true);
        
        if($response['body']['resultInfo']['resultStatus'] == "S")
        {
            return response()->json([
                'code' => 200,
                'message' => "Data Retrived Successfully...!",
                'signature' => $response['body']['txnToken'],
                'callback_url' => $callback_url
            ]);
        }
        else
        {
            return response()->json([
                'code' => 201,
                'message' => "Invalid Access Key"
            ]);
        }
        
    }
    
    function verifyPaytmPayment(Request $request){
        $order_id = $request->get("order_id");
        $paytmParams["body"] = array(
            "mid" => Setting::getValue('paytm_merchant_id'),
            "orderId" => $order_id,
        );
        
        $checksum = PaytmChecksum::generateSignature(json_encode($paytmParams["body"]), Setting::getValue('paytm_merchant_key'));
        $paytmParams["head"] = array(
            /* put generated checksum value here */
            "signature"    => $checksum
        );
    
        /* prepare JSON string for request */
        $post_data = json_encode($paytmParams);
        $url = "https://securegw.paytm.in/v3/order/status";
    
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    
        $response = json_decode(curl_exec($ch),true);
        return response()->json([
            'code' => 200,
            'message' => "Success",
            'response' => $response['body']['resultInfo']['resultStatus']
        ]);
    
    }
    
    function cashfreePayment(Request $request){
        $order_id = $request->get("order_id");
        $amount = $request->get("amount");
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://test.cashfree.com/api/v2/cftoken/order',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "orderId": "'.$order_id.'",
          "orderAmount":'.$amount.',
          "orderCurrency": "INR"
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'x-client-id: '.Setting::getValue('cashfree_client_id'),
            'x-client-secret: '.Setting::getValue('cashfree_client_secret')
          ),
        ));
        
        $response = json_decode(curl_exec($curl),true);
        curl_close($curl);
        
        return response()->json([
            'code' => 200,
            'message' => "Success",
            'response' => $response['cftoken']
        ]);
    }
    
    function createStripePayment(Request $request){
        
        $amount = $request->get("amount");
        $user_id = $request->get("user_id");
        
        try {
            $stripe = new \Stripe\StripeClient(Setting::getValue('stripe_secret_key'));

            $customer = $stripe->customers->create();

            $ephemeralKey = $stripe->ephemeralKeys->create([
            'customer' => $customer->id,
            ], [
            'stripe_version' => '2022-08-01',
            ]);

            $paymentIntent = $stripe->paymentIntents->create([
                'amount' => $request->amount*100,
                'currency' => Setting::getValue('currency'),
                'customer' => $customer->id,
                'automatic_payment_methods' => [
                    'enabled' => 'true',
                ],
            ]);
            
            $data = [
                'code' => 200,
                'message' => "Success",
                'publishableKey' => Setting::getValue('stripe_public_key'),
                'clientSecret' => $paymentIntent->client_secret,
                'ephemeralKey' => $ephemeralKey->secret,
                'customer' => $customer->id,
            ];
            
        } catch (\Stripe\Exception\CardException $e) {
            // Since it's a decline, \Stripe\Exception\CardException will be caught
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        } catch (\Stripe\Exception\RateLimitException $e) {
            // Too many requests made to the API too quickly
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        } catch (\Stripe\Exception\InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        } catch (\Stripe\Exception\AuthenticationException $e) {
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            // Network communication with Stripe failed
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send
            // yourself an email
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        } catch (Exception $e) {
            // Something else happened, completely unrelated to Stripe
            $error_msg = $e->getError()->message;
            $data = [
                'code' => 201,
                'message' => json_encode($error_msg)
            ];
        }
        
        
        return response()->json($data);
    }
    
    /**
     * Get Shorts Videos (Android App API)
     */
    public function getShortsVideos(Request $request)
    {
        try {
            $perPage = $request->input('per_page', 10);
            $page = $request->input('page', 1);
            
            $query = \App\Models\ShortsVideo::active()->ordered();
            
            // Filter by category if provided
            if ($request->has('category_id') && !empty($request->category_id)) {
                $query->where('category_id', $request->category_id);
            }
            
            // Filter by featured
            if ($request->has('featured') && $request->featured == '1') {
                $query->featured();
            }
            
            $shorts = $query->paginate($perPage);
            
            $data = [
                'code' => 200,
                'message' => 'Success',
                'data' => $shorts->items(),
                'pagination' => [
                    'current_page' => $shorts->currentPage(),
                    'total_pages' => $shorts->lastPage(),
                    'total_items' => $shorts->total(),
                    'per_page' => $shorts->perPage(),
                ]
            ];
        } catch (\Exception $e) {
            $data = [
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage()
            ];
        }
        
        return response()->json($data);
    }
    
    /**
     * Get Shorts Video Detail (Android App API)
     */
    public function getShortsVideoDetail($id)
    {
        try {
            $short = \App\Models\ShortsVideo::with('category')->find($id);
            
            if (!$short) {
                return response()->json([
                    'code' => 404,
                    'message' => 'Shorts video not found'
                ]);
            }
            
            $data = [
                'code' => 200,
                'message' => 'Success',
                'data' => $short
            ];
        } catch (\Exception $e) {
            $data = [
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage()
            ];
        }
        
        return response()->json($data);
    }
    
    /**
     * Increment Shorts Video View Count (Android App API)
     */
    public function incrementShortsView($id)
    {
        try {
            $short = \App\Models\ShortsVideo::find($id);
            
            if (!$short) {
                return response()->json([
                    'code' => 404,
                    'message' => 'Shorts video not found'
                ]);
            }
            
            $short->incrementViews();
            
            $data = [
                'code' => 200,
                'message' => 'View count updated',
                'views' => $short->views
            ];
        } catch (\Exception $e) {
            $data = [
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage()
            ];
        }
        
        return response()->json($data);
    }
    
    /**
     * Like/Unlike Shorts Video (Android App API)
     */
    public function likeShortsVideo(Request $request, $id)
    {
        try {
            $short = \App\Models\ShortsVideo::find($id);
            
            if (!$short) {
                return response()->json([
                    'code' => 404,
                    'message' => 'Shorts video not found'
                ]);
            }
            
            $action = $request->input('action', 'like'); // 'like' or 'unlike'
            
            if ($action === 'like') {
                $short->incrementLikes();
                $message = 'Video liked';
            } else {
                $short->decrementLikes();
                $message = 'Video unliked';
            }
            
            $data = [
                'code' => 200,
                'message' => $message,
                'likes' => $short->likes
            ];
        } catch (\Exception $e) {
            $data = [
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage()
            ];
        }
        
        return response()->json($data);
    }
    
    /**
     * Increment Shorts Video Share Count (Android App API)
     */
    public function shareShortsVideo($id)
    {
        try {
            $short = \App\Models\ShortsVideo::find($id);
            
            if (!$short) {
                return response()->json([
                    'code' => 404,
                    'message' => 'Shorts video not found'
                ]);
            }
            
            $short->incrementShares();
            
            $data = [
                'code' => 200,
                'message' => 'Share count updated',
                'shares' => $short->shares
            ];
        } catch (\Exception $e) {
            $data = [
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage()
            ];
        }
        
        return response()->json($data);
    }

    /**
     * Get Short Video Categories (Android App API - New Format)
     * Endpoint: /shortvideocategories
     */
    public function getShortVideoCategories()
    {
        try {
            $categories = \App\Models\ShortsCategory::where('status', '0')
                ->orderBy('orders', 'asc')
                ->get();
            
            $formattedCategories = [];
            foreach ($categories as $category) {
                $videoCount = $category->videos()->count();
                $formattedCategories[] = [
                    'id' => (string)$category->id,
                    'name' => $category->name,
                    'thumbnail' => isset($category->thumbnail) ? $category->thumbnail : '',
                    'video_count' => (string)$videoCount
                ];
            }
            
            return response()->json([
                'success' => true,
                'code' => 200,
                'message' => 'Categories fetched successfully',
                'short_video_categories' => $formattedCategories
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage(),
                'short_video_categories' => []
            ]);
        }
    }

    /**
     * Get Short Videos by Category (Android App API - New Format)
     * Endpoint: /shortvideos?category_id={id}&page={page}
     */
    public function getShortVideos(Request $request)
    {
        try {
            $categoryId = $request->input('category_id');
            $page = $request->input('page', 0);
            $perPage = 10;
            
            $query = \App\Models\ShortsVideo::where('status', 'active')
                ->orderBy('order', 'asc')
                ->orderBy('created_at', 'desc');
            
            // Filter by category if provided
            if (!empty($categoryId)) {
                $query->where('category_id', $categoryId);
            }
            
            $videos = $query->skip($page * $perPage)
                ->take($perPage)
                ->get();
            
            $formattedVideos = [];
            foreach ($videos as $video) {
                $category = $video->category;
                $formattedVideos[] = [
                    'id' => (string)$video->id,
                    'title' => $video->title,
                    'video_url' => $video->video_url,
                    'thumbnail_url' => $video->thumbnail_url ?? '',
                    'category_id' => (string)$video->category_id,
                    'category_name' => $category ? $category->name : '',
                    'premium' => '0', // Add premium logic if needed
                    'views' => (string)$video->views,
                    'likes' => (string)$video->likes
                ];
            }
            
            return response()->json([
                'success' => true,
                'code' => 200,
                'message' => 'Videos fetched successfully',
                'short_videos' => $formattedVideos
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage(),
                'short_videos' => []
            ]);
        }
    }

    /**
     * Like Short Video (Android App API - New Format)
     * Endpoint: POST /likeshortvideo
     */
    public function likeShortVideo(Request $request)
    {
        try {
            $videoId = $request->input('video_id');
            $userId = $request->input('user_id');
            
            if (empty($videoId)) {
                return response()->json([
                    'success' => false,
                    'code' => 201,
                    'message' => 'Video ID is required'
                ]);
            }
            
            $video = \App\Models\ShortsVideo::find($videoId);
            
            if (!$video) {
                return response()->json([
                    'success' => false,
                    'code' => 404,
                    'message' => 'Video not found'
                ]);
            }
            
            $video->incrementLikes();
            
            return response()->json([
                'success' => true,
                'code' => 200,
                'message' => 'Video liked successfully',
                'likes' => $video->likes
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'code' => 201,
                'message' => 'Error: ' . $e->getMessage()
            ]);
        }
    }

}
