<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ShortsCategory;
use App\Models\ShortsVideo;
use Illuminate\Support\Str;

class ShortsCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $categories = ShortsCategory::orderBy('orders', 'ASC')->paginate(150);
        return view('shorts.category.index', compact('categories'));
    }
    
    /**
     * Toggle category status
     */
    public function category_status(Request $request)
    {
        $category = ShortsCategory::find($request->get("id"));
        $category->status = ($request->get("checked") == "true") ? 0 : 1;
        $category->save();
    }
    
    /**
     * Update category order
     */
    public function category_order(Request $request)
    {
        $positions = $request->get("position");
        $ids = $request->get("parameter");
        
        $ids = json_decode($ids, true);
        $positions = json_decode($positions, true);
        
        foreach ($ids as $key => $id) {
            $category = ShortsCategory::find($id);
            $category->orders = $key + 1;
            $category->save();
        }
    }
    
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('shorts.category.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required|string|max:255',
        ]);
        
        $category = new ShortsCategory();
        $category->name = $request->get("title");
        $category->status = 0; // Set default status to active
        $category->save();
        
        return redirect()->route('shortscategory.index')
            ->with('success', 'Shorts category created successfully!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $category = ShortsCategory::findOrFail($id);
        return view('shorts.category.edit', compact('category'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title' => 'required|string|max:255',
        ]);
        
        $category = ShortsCategory::findOrFail($id);
        $category->name = $request->get("title");
        $category->save();
        
        return redirect()->route('shortscategory.index')
            ->with('success', 'Shorts category updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $category = ShortsCategory::findOrFail($id);
        
        // Check if category has videos
        $videoCount = ShortsVideo::where('category_id', $id)->count();
        
        if ($videoCount > 0) {
            return redirect()->route('shortscategory.index')
                ->with('error', "Cannot delete category! It has {$videoCount} video(s). Please reassign or delete them first.");
        }
        
        $category->delete();
        
        return redirect()->route('shortscategory.index')
            ->with('success', 'Shorts category deleted successfully!');
    }
}
