<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add new R2 configuration settings
        $settings = [
            ['field' => 'r2_endpoint', 'value' => '', 'type' => 'text'],
            ['field' => 'r2_access_key', 'value' => '', 'type' => 'text'],
            ['field' => 'r2_secret_key', 'value' => '', 'type' => 'password'],
            ['field' => 'r2_bucket', 'value' => '', 'type' => 'text'],
            ['field' => 'r2_public_domain', 'value' => '', 'type' => 'text'],
            ['field' => 'r2_enabled', 'value' => '0', 'type' => 'boolean'],
        ];

        foreach ($settings as $setting) {
            DB::table('settings')->insert([
                'field' => $setting['field'],
                'value' => $setting['value'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove R2 settings
        DB::table('settings')->whereIn('field', [
            'r2_endpoint',
            'r2_access_key',
            'r2_secret_key',
            'r2_bucket',
            'r2_public_domain',
            'r2_enabled',
        ])->delete();
    }
};
