<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shorts_category', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('status')->default(0); // 0=active, 1=inactive
            $table->integer('orders')->default(0);
            $table->timestamps();
            
            // Index for better performance
            $table->index(['status', 'orders']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shorts_category');
    }
};
