@extends('main')

@section('content')
    
    <div class="row">
        <div class="col-12">
            <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header pb-0">
              <div class="d-flex align-items-center">
                <p class="mb-0 font-weight-bolder">Cloudflare R2 Storage Settings</p>
                <label class="btn btn-{{ session('success') ? 'success' : 'primary' }} btn-sm ms-auto">
                    {{ session('success') ?? session('error') ?? 'Configure R2 Storage' }}
                </label>
              </div>
            </div>
            <div class="card-body">
                <form method="post" action="{{ route('settings.r2.update') }}" id="r2SettingsForm">
                    @csrf
                    <div class="row">
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Enable R2 Storage</label>
                            <select class="fstdropdown-select form-control" name="r2_enabled">
                                <option value="0" {{ old('r2_enabled', App\Models\Setting::getValue('r2_enabled')) == '0' ? 'selected' : '' }}>Disabled</option>
                                <option value="1" {{ old('r2_enabled', App\Models\Setting::getValue('r2_enabled')) == '1' ? 'selected' : '' }}>Enabled</option>
                            </select>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">R2 Endpoint URL <b style="color:red">{{ $errors->first('r2_endpoint') }}</b></label>
                            <input class="form-control" name="r2_endpoint" type="url" value="{{ old('r2_endpoint', App\Models\Setting::getValue('r2_endpoint')) }}" placeholder="https://abc123.r2.cloudflarestorage.com">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Access Key ID <b style="color:red">{{ $errors->first('r2_access_key') }}</b></label>
                            <input class="form-control" name="r2_access_key" type="text" value="{{ old('r2_access_key', App\Models\Setting::getValue('r2_access_key')) }}" placeholder="Enter Access Key">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Secret Access Key <b style="color:red">{{ $errors->first('r2_secret_key') }}</b></label>
                            <input class="form-control" id="r2_secret_key" name="r2_secret_key" type="password" value="{{ old('r2_secret_key', App\Models\Setting::getValue('r2_secret_key')) }}" placeholder="Enter Secret Key">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Bucket Name <b style="color:red">{{ $errors->first('r2_bucket') }}</b></label>
                            <input class="form-control" name="r2_bucket" type="text" value="{{ old('r2_bucket', App\Models\Setting::getValue('r2_bucket')) }}" placeholder="my-bucket">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Public Domain <b style="color:red">{{ $errors->first('r2_public_domain') }}</b></label>
                            <input class="form-control" name="r2_public_domain" type="text" value="{{ old('r2_public_domain', App\Models\Setting::getValue('r2_public_domain')) }}" placeholder="pub-123.r2.dev">
                          </div>
                        </div>
                        
                        <div class="col-md-12">
                          <div class="form-group d-flex gap-2">
                              <button type="button" class="btn btn-info col-md-3" id="testConnectionBtn">
                                  <i class="fas fa-plug"></i> Test Connection
                              </button>
                              
                              @if(Session::get('admin_type') == "Demo")
                              <div class="btn btn-primary col-md-3 demo_action">Save Settings</div>
                              @else
                              <input class="btn btn-primary col-md-3" type="submit" value="Save Settings">
                              @endif
                          </div>
                        </div>
                     
                    </div>
                </form>
            </div>
          </div>
        </div>
        
      </div>
        </div>
    </div>

<script type="text/javascript">
    // Initialize custom dropdowns
    $(document).ready(function() {
        create_custom_dropdowns();
    });
    
    // Test R2 Connection
    $('#testConnectionBtn').click(function() {
        var btn = $(this);
        var originalHtml = btn.html();
        
        // Get form values
        var endpoint = $('input[name="r2_endpoint"]').val();
        var accessKey = $('input[name="r2_access_key"]').val();
        var secretKey = $('input[name="r2_secret_key"]').val();
        var bucket = $('input[name="r2_bucket"]').val();
        
        // Validate fields
        if (!endpoint || !accessKey || !secretKey || !bucket) {
            toastr.error('Please fill all R2 credentials first');
            return;
        }
        
        // Disable button and show loading
        btn.prop('disabled', true);
        btn.html('<i class="fas fa-spinner fa-spin"></i> Testing...');
        
        // Make AJAX request
        $.ajax({
            url: "{{ url('/shorts-test-r2') }}",
            type: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                r2_endpoint: endpoint,
                r2_access_key: accessKey,
                r2_secret_key: secretKey,
                r2_bucket: bucket
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message || 'R2 connection successful!');
                } else {
                    toastr.error(response.message || 'R2 connection failed!');
                }
            },
            error: function(xhr) {
                toastr.error('Connection test failed. Please check your credentials.');
            },
            complete: function() {
                btn.prop('disabled', false);
                btn.html(originalHtml);
            }
        });
    });
</script>
@endsection
