@extends('main')

@section('content')
    
    <div class="row">
        <div class="col-12">
            <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header pb-0">
              <div class="d-flex align-items-center">
                <p class="mb-0 font-weight-bolder">Add Shorts Category</p>
                <a href="{{ route('shortscategory.index') }}" class="btn btn-secondary btn-sm ms-auto">
                    <i class="fas fa-arrow-left"></i> Back
                </a>
              </div>
            </div>
            <div class="card-body">
                <form method="post" action="{{ route('shortscategory.store') }}" id="addform">
                    @csrf
                    <div class="row">
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="title" class="form-control-label">Category Name <span class="text-danger">*</span></label>
                            <input class="form-control @error('title') is-invalid @enderror" 
                                   name="title" 
                                   type="text" 
                                   placeholder="e.g. Festival, Comedy, Dance" 
                                   value="{{ old('title') }}"
                                   required>
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Enter category name (e.g., Festival, Comedy, Dance, Music, etc.)
                            </small>
                          </div>
                        </div>
                        
                        <div class="col-md-12">
                            <hr>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> <strong>Note:</strong> Categories help organize your shorts videos. After creating a category, you can assign videos to it when uploading or editing.
                            </div>
                        </div>
                        
                        <div class="col-md-12" >
                          <div class="form-group">
                              
                              @if(Session::get('admin_type') == "Demo")
                              <div class="btn btn-primary col-md-6 demo_action">Submit</div>
                              @else
                              <button class="btn btn-primary col-md-6" type="submit">
                                  <i class="fas fa-save"></i> Create Category
                              </button>
                              @endif
                            
                            <a href="{{ route('shortscategory.index') }}" class="btn btn-secondary col-md-3">Cancel</a>
                          </div>
                        </div>
                     
                    </div>
                </form>
            </div>
          </div>
        </div>
        
      </div>
        </div>
    </div>

@endsection
