@extends('main')

@section('content')
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <div class="row">
        <div class="col-12">
          <div class="card mb-4">
              
            <div class="card-header py-0 bg-primary">
                <div class="d-flex align-items-center">
                   <h6 class="text-white" >Shorts Video Categories</h6>
                    
                    <div class="ms-auto mt-3">
                        <a href="{{ route('shortscategory.create')}}" class="btn btn-success "><i class="fas fa-plus"></i> Add New Category
                        </a>
                    </div>
                </div>
            </div>
             
            <div class="card-body mt-n4">
                
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                
                <div class="row mb" >
                    
            <!--start-->
            <div class="table-responsive p-0">
                <table class="table align-items-center mb-0 sort">
                  <thead>
                    <tr>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">ID</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Name</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Videos Count</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Status</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Created</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    @forelse ($categories as $category)
                       <tr id="{{ $category->id }}">
                            <td class="align-middle text-center text-sm">
                                <p class="text-xs font-weight-bold mb-0">{{ $category->id }}</p>
                            </td>
                            
                            <td>
                               <h6 class="mb-0 text-sm title">{{ $category->name }}</h6>
                            </td>
                            
                            <td class="align-middle text-center">
                                <span class="badge badge-sm bg-gradient-info">{{ $category->allVideos()->count() }} videos</span>
                            </td>
                            
                            <td class="align-middle">
                                <div class="form-switch align-items-center justify-content-center" >
                                    <input class="form-check-input status-switch" type="checkbox" data-id="{{$category->id}}" @if($category->status==0) checked @endif>
                                </div>
                            </td>
                            
                            <td class="align-middle text-center">
                                <span class="text-secondary text-xs font-weight-bold">{{date('d M, y',strtotime($category->created_at))}}</span>
                            </td>
                            
                            
                            <td class="align-middle">
                            <div class="ms-auto text-end align-middle text-center text-sm">
                                <a class="btn btn-icon-only btn-rounded btn-warning"><i class="fas fa-hand-paper"></i></a>
                                <a href="#" data-id="{{$category->id}}" data-bs-toggle="modal" data-bs-target="#deleteModal" class="btn btn-icon-only btn-rounded btn-danger"><i class="far fa-trash-alt"></i></a>
                                <a class="btn btn-icon-only btn-rounded btn-success" href="{{url('/shortscategory/'.$category->id.'/edit')}}"><i class="fas fa-pencil-alt"></i></a>
                            </div>
                            </td>
                       </tr>
                       
                        <form action="{{ url('shortscategory/'.$category->id) }}" method="POST" id="form-{{ $category->id }}">
                            @method('DELETE')
                            @csrf
                            <input type="hidden" name="id" value="{{ $category->id }}">
                        </form>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-4">
                                <p class="text-muted">No categories found. <a href="{{ route('shortscategory.create') }}">Add your first category</a></p>
                            </td>
                        </tr>
                    @endforelse
                  </tbody>
                </table>
              </div>
              
              <!--end-->
                      
                </div>
                    
            </div>
                
                <div class="d-flex justify-content-center">{{ $categories->links() }}</div>

            </div>
          </div>
        </div>
    </div>

<div id="deleteModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Confirm Delete</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p>Are you sure you want to delete this category?</p>
          <p class="text-warning"><small><i class="fas fa-exclamation-triangle"></i> Note: You cannot delete a category that has videos. Please reassign or delete the videos first.</small></p>
        </div>
        <div class="modal-footer">
          
          @if(Session::get('admin_type') == "Demo")
          <button class="btn btn-danger demo_action" data-bs-dismiss="modal">Delete</button>
          @else
          <button id="delete_btn" class="btn btn-danger">Delete</button>
          @endif
          
          <button class="btn btn-default" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>

<script>
    $(function() {
      $(".sort").sortable({
        items: "> tbody > tr",
        stop: function(event, ui) {
          var parameter = $(this).sortable("toArray");
          var position = [];
          $.each(parameter, function(index, value) {
            position.push(index + 1);
          });
          console.log(position,parameter);
          $.ajax({
              type: "POST",
              url: "{{ url('/shorts-category-order') }}",
              data: { position : JSON.stringify(position) , parameter : JSON.stringify(parameter)},
              headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
              success: function(data) {
                  
                  toastr.success("Order saved successfully");
                  
              },
              error (data) {
                  toastr.error("Error updating order");
              }
              
          });
        }
      });
    });

    $("#deleteModal").on('show.bs.modal', function(e){
        var id = e.relatedTarget.dataset.id;
        $("#delete_btn").attr("data-submit",id);
    });
    
    $("#delete_btn").on("click",function(){
        var id=$(this).data("submit");
        $("#form-"+id).submit();
    });
    
    $(".status-switch").change(function(){
        var checked = $(this).is(':checked');
        var id = $(this).data("id");
        
        $.ajax({
          type: "POST",
          url: "{{ url('/shorts-category-status') }}",
          data: { checked : checked , id : id},
          headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
          success: function(data) {
              
              if(checked){
                  toastr.success("Category Activated");
              }else{
                  toastr.success("Category Deactivated");
              }
          },
          error (data) {
              toastr.error("Error updating status");
          }
          
        });
    });
      
    $(document).ready(function () {
       create_custom_dropdowns();
    });
    
</script>
@endsection
