@extends('main')

@section('content')
    
    <div class="row">
        <div class="col-12">
            <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header pb-0">
              <div class="d-flex align-items-center">
                <p class="mb-0 font-weight-bolder">Add New Shorts Video</p>
                <label class="btn btn-{{ $errors->first('iserror') == 'false' ? 'success' : 'primary'  }} btn-sm ms-auto">{{ $errors->first('response') }}</label>
              </div>
            </div>
            <div class="card-body">
                <form method="post" action="{{ route('shorts.store') }}" id="addform" enctype="multipart/form-data" >
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Title <b style="color:red">{{ $errors->first('title') }}</b></label>
                            <input class="form-control" name="title" type="text" placeholder="Enter shorts video title" value="{{ old('title') }}" required>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Description</label>
                            <input class="form-control" name="description" type="text" placeholder="Enter description" value="{{ old('description') }}">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Select Category</label>
                            
                            <select class="fstdropdown-select form-control" id="category_id" name="category_id">
                                <option value="">Select Category</option>
                                @foreach ($categories as $category)
                                <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                            
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Video(s) <b style="color:red">{{ $errors->first('video') }}</b></label>
                            <input class="form-control" type="file" id="video" name="videos[]" accept=".mp4,.mov,.avi" multiple>
                            <small class="text-muted">You can select multiple videos (Max: 200MB each)</small>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Thumbnail <label class="text-sm"> (optional)</label></label>
                            <input class="form-control" type="file" id="thumbnail" name="thumbnail" accept=".jpg, .png, jpeg, .PNG, .JPG, .JPEG">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Display Order</label>
                            <input class="form-control" name="order" type="number" value="{{ old('order', 0) }}" min="0">
                            <small class="text-muted">Lower numbers appear first</small>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Featured</label>
                            <select class="fstdropdown-select form-control" name="is_featured">
                                <option value="0" {{ old('is_featured', 0) == 0 ? 'selected' : '' }}>Normal</option>
                                <option value="1" {{ old('is_featured') == 1 ? 'selected' : '' }}>Featured</option>
                            </select>
                          </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-control-label">Upload Queue</label>
                                <div id="uploadQueue" class="border rounded p-3" style="min-height: 100px; background: #f8f9fa;">
                                    <p class="text-muted text-center mb-0">Select videos to see upload progress</p>
                                </div>
                            </div>
                        </div>
                        
                    
                        <div class="col-md-12" >
                          <div class="form-group">
                              
                              @if(Session::get('admin_type') == "Demo")
                              <div class="btn btn-primary col-md-6 demo_action">Submit</div>
                              @else
                              <input class="btn btn-primary col-md-6" type="submit" value="Submit">
                              @endif
                            
                            
                          </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
      </div>
        </div>
    </div>
<script type="text/javascript">
$(document).ready(function() {
    create_custom_dropdowns();
    
    let selectedFiles = [];
    let uploadedCount = 0;
    
    // Handle file selection
    $('#video').on('change', function(e) {
        selectedFiles = Array.from(e.target.files);
        displayFileQueue();
    });
    
    // Display selected files in queue
    function displayFileQueue() {
        if (selectedFiles.length === 0) {
            $('#uploadQueue').html('<p class="text-muted text-center mb-0">Select videos to see upload progress</p>');
            return;
        }
        
        let html = '';
        selectedFiles.forEach((file, index) => {
            const fileSize = (file.size / (1024 * 1024)).toFixed(2);
            html += `
                <div class="upload-item mb-3" data-index="${index}">
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <div>
                            <strong>${file.name}</strong>
                            <span class="text-muted ms-2">(${fileSize} MB)</span>
                        </div>
                        <span class="badge bg-secondary upload-status">Pending</span>
                    </div>
                    <div class="progress" style="height: 25px;">
                        <div class="progress-bar progress-bar-striped progress-bar-animated" 
                             role="progressbar" style="width: 0%" 
                             data-index="${index}">0%</div>
                    </div>
                </div>
            `;
        });
        $('#uploadQueue').html(html);
    }
    
    // Handle form submission
    $('#addform').on('submit', function(e) {
        e.preventDefault();
        
        if (selectedFiles.length === 0) {
            toastr.error('Please select at least one video');
            return;
        }
        
        // Disable submit button
        $('input[type="submit"]').prop('disabled', true).val('Uploading...');
        $('.demo_action').text('Uploading...');
        
        uploadedCount = 0;
        uploadNextFile(0);
    });
    
    // Upload files sequentially with progress
    function uploadNextFile(index) {
        if (index >= selectedFiles.length) {
            // All files uploaded
            toastr.success(`Successfully uploaded ${uploadedCount} video(s)!`);
            setTimeout(function() {
                window.location.href = "{{ route('shorts.index') }}";
            }, 1500);
            return;
        }
        
        const file = selectedFiles[index];
        const formData = new FormData();
        
        // Add form fields
        formData.append('video', file);
        formData.append('title', $('input[name="title"]').val() + (selectedFiles.length > 1 ? ` (${index + 1})` : ''));
        formData.append('description', $('input[name="description"]').val());
        formData.append('category_id', $('select[name="category_id"]').val());
        formData.append('order', $('input[name="order"]').val());
        formData.append('is_featured', $('select[name="is_featured"]').val());
        formData.append('_token', "{{ csrf_token() }}");
        
        // Add thumbnail only for first video
        if (index === 0 && $('#thumbnail')[0].files.length > 0) {
            formData.append('thumbnail', $('#thumbnail')[0].files[0]);
        }
        
        // Update status
        $(`.upload-item[data-index="${index}"] .upload-status`)
            .removeClass('bg-secondary')
            .addClass('bg-info')
            .text('Uploading');
        
        // Upload via AJAX
        $.ajax({
            url: "{{ route('shorts.store') }}",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhr: function() {
                const xhr = new window.XMLHttpRequest();
                // Upload progress
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        const percentComplete = Math.round((e.loaded / e.total) * 100);
                        $(`.progress-bar[data-index="${index}"]`)
                            .css('width', percentComplete + '%')
                            .text(percentComplete + '%');
                    }
                }, false);
                return xhr;
            },
            success: function(response) {
                uploadedCount++;
                $(`.upload-item[data-index="${index}"] .upload-status`)
                    .removeClass('bg-info')
                    .addClass('bg-success')
                    .text('Completed');
                $(`.progress-bar[data-index="${index}"]`)
                    .removeClass('progress-bar-animated')
                    .addClass('bg-success');
                
                // Upload next file
                uploadNextFile(index + 1);
            },
            error: function(xhr) {
                $(`.upload-item[data-index="${index}"] .upload-status`)
                    .removeClass('bg-info')
                    .addClass('bg-danger')
                    .text('Failed');
                $(`.progress-bar[data-index="${index}"]`)
                    .removeClass('progress-bar-animated')
                    .addClass('bg-danger');
                
                const error = xhr.responseJSON?.message || 'Upload failed';
                toastr.error(`${file.name}: ${error}`);
                
                // Continue with next file
                uploadNextFile(index + 1);
            }
        });
    }
});
</script>
@endsection
