@extends('main')

@section('content')
    
    <div class="row">
        <div class="col-12">
            <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header pb-0">
              <div class="d-flex align-items-center">
                <p class="mb-0 font-weight-bolder">Edit Shorts Video</p>
                <label class="btn btn-{{ $errors->first('iserror') == 'false' ? 'success' : 'primary'  }} btn-sm ms-auto">{{ $errors->first('response') }}</label>
              </div>
            </div>
            <div class="card-body">
                <form method="post" action="{{ route('shorts.update', $short->id) }}" id="addform" enctype="multipart/form-data" >
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Title <b style="color:red">{{ $errors->first('title') }}</b></label>
                            <input class="form-control" name="title" type="text" value="{{ old('title', $short->title) }}" required>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Description</label>
                            <input class="form-control" name="description" type="text" value="{{ old('description', $short->description) }}">
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Select Category</label>
                            
                            <select class="fstdropdown-select form-control" id="category_id" name="category_id">
                                <option value="">Select Category</option>
                                @foreach ($categories as $category)
                                <option value="{{ $category->id }}" {{ old('category_id', $short->category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                            
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">New Video <label class="text-sm"> (optional)</label></label>
                            <input class="form-control" type="file" id="video" name="video" accept=".mp4,.mov,.avi">
                            <small class="text-muted">Leave empty to keep current video</small>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">New Thumbnail <label class="text-sm"> (optional)</label></label>
                            <input class="form-control" type="file" id="thumbnail" name="thumbnail" accept=".jpg, .png, jpeg, .PNG, .JPG, .JPEG">
                            <small class="text-muted">Leave empty to keep current thumbnail</small>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Display Order</label>
                            <input class="form-control" name="order" type="number" value="{{ old('order', $short->order) }}" min="0">
                            <small class="text-muted">Lower numbers appear first</small>
                          </div>
                        </div>
                        
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Featured</label>
                            <select class="fstdropdown-select form-control" name="is_featured">
                                <option value="0" {{ old('is_featured', $short->is_featured) == 0 ? 'selected' : '' }}>Normal</option>
                                <option value="1" {{ old('is_featured', $short->is_featured) == 1 ? 'selected' : '' }}>Featured</option>
                            </select>
                          </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-control-label">Upload Progress</label>
                                <div id="uploadProgress" style="display: none;">
                                    <div class="progress" style="height: 25px;">
                                        <div class="progress-bar progress-bar-striped progress-bar-animated" 
                                             role="progressbar" style="width: 0%" 
                                             id="progressBar">0%</div>
                                    </div>
                                    <p class="text-muted text-center mt-2 mb-0" id="uploadStatus">Preparing upload...</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card-body mt-n3">
                            <label class="form-label">Current Video Preview</label>
                            <div class="mb" id="previewImages">
                                <video width="250" height="auto" controls>
                                   <source src="{{ $short->video_url }}" id="videoplayer">
                                </video>
                            </div>
                        </div>
                        
                    
                        <div class="col-md-12" >
                          <div class="form-group">
                              
                              @if(Session::get('admin_type') == "Demo")
                              <div class="btn btn-primary col-md-6 demo_action">Update</div>
                              @else
                              <input class="btn btn-primary col-md-6" type="submit" value="Update">
                              @endif
                            
                            
                          </div>
                        </div>
                     
                    </div>
                </form>
            </div>
          </div>
        </div>
        
      </div>
        </div>
    </div>
<script type="text/javascript">
$(document).ready(function() {
    create_custom_dropdowns();
    
    let hasNewVideo = false;
    
    // Preview video on selection
    $("#video").change(function () {
        if (this.files && this.files[0]) {
            hasNewVideo = true;
            var $source = $('#videoplayer');
            $source[0].src = URL.createObjectURL(this.files[0]);
            $source.parent()[0].load();
        }
    });
    
    // Handle form submission with progress
    $('#addform').on('submit', function(e) {
        e.preventDefault();
        
        // If no new video/thumbnail, submit normally
        if (!hasNewVideo && !$('#thumbnail')[0].files.length) {
            this.submit();
            return;
        }
        
        const formData = new FormData(this);
        
        // Show progress bar
        $('#uploadProgress').show();
        $('#progressBar').removeClass('bg-success bg-danger').addClass('progress-bar-animated');
        $('#uploadStatus').text('Uploading...');
        
        // Disable submit button
        $('input[type="submit"]').prop('disabled', true).val('Uploading...');
        $('.demo_action').text('Uploading...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhr: function() {
                const xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        const percentComplete = Math.round((e.loaded / e.total) * 100);
                        $('#progressBar')
                            .css('width', percentComplete + '%')
                            .text(percentComplete + '%');
                        $('#uploadStatus').text(`Uploading... ${percentComplete}%`);
                    }
                }, false);
                return xhr;
            },
            success: function(response) {
                $('#progressBar')
                    .removeClass('progress-bar-animated')
                    .addClass('bg-success')
                    .css('width', '100%')
                    .text('100%');
                $('#uploadStatus').text('Upload completed!');
                toastr.success('Video updated successfully!');
                setTimeout(function() {
                    window.location.href = "{{ route('shorts.index') }}";
                }, 1500);
            },
            error: function(xhr) {
                $('#progressBar')
                    .removeClass('progress-bar-animated')
                    .addClass('bg-danger');
                const error = xhr.responseJSON?.message || 'Upload failed';
                $('#uploadStatus').text('Upload failed: ' + error);
                toastr.error(error);
                $('input[type="submit"]').prop('disabled', false).val('Update');
                $('.demo_action').text('Update');
            }
        });
    });
});
</script>
@endsection
