@extends('main')

@section('content')
    
    <div class="row">
        <div class="col-12">
            <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-header pb-0">
              <div class="d-flex align-items-center">
                <p class="mb-0 font-weight-bolder">Edit Subscription</p>
                <label class="btn btn-{{ $errors->first('iserror') == 'false' ? 'success' : 'primary'  }} btn-sm ms-auto">{{ $errors->first('response') }}</label>
                
              </div>
            </div>
            <div class="card-body">
                <!--<img src="{{ asset('storage/images/test.jpg') }}">-->
                <form method="post" action="{{ route('subscription.update',$subscription->id) }}" id="addform" enctype="multipart/form-data" >
                    
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Enter Name<b style="color:red">{{ $errors->first('title') }}</b></label>
                            <input class="form-control" name="title" type="text" value="{{ $subscription->name }}" required>
                          </div>
                          
                         <div class="form-group">
                            <div class="">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="example-text-input" class="form-control-label">Price {{ App\Models\Setting::getValue('currency') }}</label>
                                        <input class="form-control" name="price" type="number" value="{{ $subscription->price }}" required>
                                    </div>
                                    <div class="col-6">
                                        <label for="example-text-input" class="form-control-label">Discount Price {{ App\Models\Setting::getValue('currency') }}</label>
                                        <input class="form-control" name="discount_price" type="number" value="{{ $subscription->discount_price }}" required>
                                    </div>
                                </div>
                            </div>
                          </div>
                          
                          
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Enter Duration</label>
                            <div class="">
                                <div class="row">
                                    <div class="col-6">
                                        <input class="form-control" name="value" type="number" value="{{ $subscription->value }}"  required>
                                    </div>
                                    <div class="col-6">
                                    
                                    
                                    <select class="form-control" id="type" name="type" required>
                                        <option value="DAY" >Day</option>
                                        <option value="WEEK" @if($subscription->type == 'WEEK') selected @endif>Week</option>
                                        <option value="MONTH" @if($subscription->type == 'MONTH') selected @endif>Month</option>
                                        <option value="YEAR" @if($subscription->type == 'YEAR') selected @endif>Year</option>
                                    </select>
                                    
                                    
                                    </div>
                                </div>
                            </div>
                            
                            
                          </div>
                          <div class="form-group">
                            <div class="">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="example-text-input" class="form-control-label">Daily Limit</label>
                                        <input class="form-control" name="daily_limit" type="text" value="{{ $subscription->daily_limit }}" required>
                                    </div>
                                    <div class="col-6">
                                        <label for="example-text-input" class="form-control-label">Total Posts Limit</label>
                                        <input class="form-control" name="post_limit" type="text" value="{{ $subscription->posts_limit }}" required>
                                    </div>
                                </div>
                            </div>
                          </div>
                          
                          <div class="form-group">
                            <div class="">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="example-text-input" class="form-control-label">Business Limit</label>
                                        <input class="form-control" name="business_limit" type="text" value="{{ $subscription->business_limit }}" required>
                                    </div>
                                    <div class="col-6">
                                        <label for="example-text-input" class="form-control-label">Political Limit</label>
                                        <input class="form-control" name="political_limit" type="text" value="{{ $subscription->political_limit }}" required>
                                    </div>
                                </div>
                            </div>
                          </div>
                          
                          
                          <div class="form-group">
                            <div style="margin-left:18px;">
                                <div class="row">
                                    <div class="col-6 form-switch">
                                        <input class="form-check-input" name="festival" type="checkbox" id="festival" @if($subscription->festival=='0') checked @endif>
                                        <label class="form-check-label" for="festival">Festival Posts</label>
                                    </div>
                                    <div class="col-6 form-switch">
                                        <input class="form-check-input" name="business" type="checkbox" id="business" @if($subscription->business=='0') checked @endif>
                                        <label class="form-check-label" for="business">Business Post</label>
                                    </div>
                                </div>
                            </div>
                          </div>
                          
                          <div class="form-group">
                            <div style="margin-left:18px;">
                                <div class="row">
                                    <div class="col-6 form-switch">
                                        <input class="form-check-input" name="political" type="checkbox" id="political" @if($subscription->political=='0') checked @endif>
                                        <label class="form-check-label" for="political">Political Posts</label>
                                    </div>
                                    <div class="col-6 form-switch">
                                        <input class="form-check-input" name="video" type="checkbox" id="video" @if($subscription->video=='0') checked @endif>
                                        <label class="form-check-label" for="video">Video Post</label>
                                    </div>
                                </div>
                            </div>
                          </div>
                          
                          <div class="form-group">
                            <div style="margin-left:18px;">
                                <div class="row">
                                    <div class="col-6 form-switch">
                                        <input class="form-check-input" name="automation" type="checkbox" id="political" @if($subscription->automation=='0') checked @endif>
                                        <label class="form-check-label" for="automation">Whatsapp Automation</label>
                                    </div>
                                </div>
                            </div>
                          </div>
                          
                          <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Image <b style="color:red">{{ $errors->first('image_posts') }}</b></label>
                            <input class="form-control" type="file" id="image_posts" name="image" accept=".jpg, .png, jpeg, .PNG, .JPG, .JPEG" onchange="fileValidation()">
                          </div>
                          
                          <div class="row mb" id="previewImages">
                                <div class='imageCard col-xl-2 col-sm-3 mb-2'>
                                  <div class='avatar avatar-xxl position-relative'>
                                    <img src='{{ asset($subscription->image) }}' id='imge' class='border-radius-md' alt='team-2'>
                                  </div>
                                </div>
                            </div>
                        </div>
                        
                        
                        <div class="col-md-6">
                            <label for="example-text-input" class="form-control-label">Plan Benefit :</label>
                            <div class="text-center">
                                <span id="add_plan"><i class="btn btn-primary col-md-12 fa fa-plus"></i></span>
                            </div>
                                    
                            <div id="add_text">
                                @if($plan_detail != null)
                                @foreach($plan_detail as $value)
                                <div class="row mb-2"><div class="col-11"><input type="text" class="form-control" name="detail[]" value="{{$value}}" placeholder="Enter Detail"></div><div class="col-1"><button type="button" class="btn btn-danger remove"><i class="fa fa-close"></i></button></div></div>
                                @endforeach
                                @endif
                            </div>
                        </div>
                        
                        
                        <div class="col-md-12" >
                          <div class="form-group">
   
                            @if(Session::get('admin_type') == "Demo")
                              <div class="btn btn-primary col-md-6 demo_action">Submit</div>
                              @else
                              <input class="btn btn-primary col-md-6" type="submit" value="Submit">
                              @endif
                            
                          </div>
                        </div>
                     
                    </div>
                </form>
            </div>
          </div>
        </div>
        
      </div>
        </div>
    </div>
<!--<p class='remove pull-right bg-danger' style='cursor:pointer;position: absolute;top: 0px;right: 15px;padding: 6px 10px;' id='"+i+"'><i class='fa fa-close'></i></p>-->
<script type="text/javascript">

    function fileValidation(){
        var fileInput = document.getElementById('image_posts');
        if (fileInput.files && fileInput.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById("previewImages").innerHTML = "";
                $('#previewImages').append(
                "<div class='imageCard col-xl-2 col-sm-3 mb-2'>"+
                  "<div class='avatar avatar-xxl position-relative'>"+
                    "<img src='"+e.target.result+"' id='imge' class='border-radius-md' alt='team-2'>"+
                  "</div>"+
                "</div>");
            };
            reader.readAsDataURL(fileInput.files[0]);
        }
    }
    
    $(function() {
        $('#add_plan').on('click', function(e){
            e.preventDefault();
            $('#add_text').append('<div class="row mb-2"><div class="col-11"><input type="text" class="form-control" name="detail[]" placeholder="Enter Detail"></div><div class="col-1"><button type="button" class="btn btn-danger remove"><i class="fa fa-close"></i></button></div></div>');
        });
        $(document).on('click', 'button.remove', function( e ) {
            e.preventDefault();
            $(this).closest( 'div.row' ).remove();
        });
    });
    
    $(document).ready(function () {
        create_custom_dropdowns();
    });

</script>
@endsection