

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
          <div class="card mb-4">
              
            <div class="card-header py-0 bg-primary">
                <div class="d-flex align-items-center">
                   <h6 class="text-white mt-2" >Transaction</h6>
                </div>
            </div>
             
            <div class="card-body mt-n4">
                
                <div class="row mb" >
                    
            <!--start-->
            <div class="table-responsive p-0">
                <table class="table align-items-center mb-0">
                  <thead>
                    <tr>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">ID</th>
                      <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Details</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Plan</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Promocode</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Amount</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Recipt</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Payment Id</th>
                      <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Created</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <tr>
                            <td class="align-middle text-center text-sm">
                                <p class="text-xs font-weight-bold mb-0"><?php echo e($transaction->id); ?></p>
                            </td>
                            
                            <td>
                               <div class="d-flex py-1">
                                  <div>
                                    <img src="<?php if($transaction->user->profile_pic): ?> <?php echo e(url($transaction->user->profile_pic)); ?> <?php else: ?> <?php echo e(url('/images/placeholder.jpg')); ?> <?php endif; ?>" class="avatar avatar-xl me-3" alt="user1">
                                  </div>
                                  <a href="<?php echo e(secure_url('/users/'.$transaction->user_id)); ?>">
                                  <div class="d-flex flex-column justify-content-center" >
                                    <h6 class="mb-0" ><?php echo e($transaction->user->name); ?></h6>
                                    <p class="mb-0 text-sm"><?php if($transaction->user->email): ?> <?php echo e($transaction->user->email); ?> <?php else: ?> <?php echo e($transaction->user->number); ?> <?php endif; ?></p>
                                  </div>
                                  </a>
                                </div>
                            </td>
                            
                            <td class="align-middle text-center text-sm">
                                <p class="text-xs font-weight-bold mb-0"><?php echo e($transaction->plan); ?></p>
                            </td>
                            
                            <td class="align-middle text-center text-sm">
                                <p class="text-xs font-weight-bold mb-0"><?php echo e($transaction->promocode); ?></p>
                            </td>
                            
                            <td class="align-middle text-center text-sm">
                                <p class="badge badge-sm bg-gradient-success"><?php echo e($transaction->amount); ?></p>
                            </td>
                            
                            <td class="align-middle text-center text-sm">
                                <?php if($transaction->receipt != ""): ?>
                                <a style="color:blue;" href="<?php echo e(url($transaction->receipt)); ?>">View</p>
                                <?php endif; ?>
                            </td>
                            
                            <td class="align-middle text-center text-sm">
                                <?php if($transaction->status == "pending"): ?>
                                 <button onclick="completePayment(<?php echo e($transaction->id); ?>)" class="btn btn-sm btn-dark" style="width:60px;padding:2px;margin:2px">
                                    Complete
                                 </button>
                                <?php else: ?>
                                <p class="text-xs font-weight-bold mb-0"><?php echo e($transaction->status); ?></p>
                                <?php endif; ?>
                            </td>
                            
                            <td class="align-middle text-center text-sm">
                                <p class="text-xs font-weight-bold mb-0"><?php echo e($transaction->transaction_id); ?></p>
                            </td>
                            
                            <td class="align-middle text-center">
                                <span class="text-secondary text-xs font-weight-bold"><?php echo e(date('d M, y',strtotime($transaction->created_at))); ?></span>
                            </td>
                            
                       </tr>
                       
                        <form action="<?php echo e(url('contacts/'.$transaction->id)); ?>" method="POST" id="form-<?php echo e($transaction->id); ?>">
                            <?php echo method_field('DELETE'); ?>
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e($transaction->id); ?>">
                        </form>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
            </div>
              
              <!--end-->
                      
                </div>
                    
            </div>
                
                <div class="d-flex justify-content-center"><?php echo e($transactions->links()); ?></div>

            </div>
          </div>
        </div>
    </div>

<div id="deleteModal" class="modal fade" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <p>Are you sure you want to Delete ?</p>
        </div>
        <div class="modal-footer">
          
          <?php if(Session::get('admin_type') == "Demo"): ?>
          <button class="btn btn-danger demo_action" data-dismiss="modal">Delete</button>
          <?php else: ?>
          <button id="delete_btn" class="btn btn-danger">Delete</button>
          <?php endif; ?>
          
          <button class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>

<script>
    function completePayment(id){
        $.ajax({
          type: "POST",
          url: "<?php echo e(secure_url('/complete-offline-payment')); ?>",
          data: { id : id},
          headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
          success: function(data) {
              location.reload();
          },
          error (data) {
              toastr.error(JSON.stringify(data));
          }
          
        });
    }
    $("#deleteModal").on('show.bs.modal', function(e){
        var id = e.relatedTarget.dataset.id;
        $("#delete_btn").attr("data-submit",id);
    });
    
    $("#delete_btn").on("click",function(){
        var id=$(this).data("submit");
        $("#form-"+id).submit();
    });
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dpstatus/public_html/resources/views/transaction/index.blade.php ENDPATH**/ ?>